/* 
 * File:   menu.h
 * Author: User
 *
 * Created on 19 November 2015, 9:44 AM
 */

#ifndef MENU_H
#define	MENU_H

#ifdef	__cplusplus
extern "C" {
#endif

typedef enum { submenu, set_clockmode, set_time, set_date, toggle, cycle, updownlist, numeric, numeric_tz, numeric_any, numeric_sec, numeric_hz, numeric_pct, alarm_toggle, alarm_time, alarm_time_group, ircode, show_tznum, show_tzname, show_lat, show_lon, show_num_sats, show_autodim_vals } menutype;
typedef enum { show_time, show_date, show_dow, show_menu, show_ir_code, set_ir_code, set_ir_codes, show_timer_up, show_timer_down, show_timer_lap, set_timer } clockmode;

typedef struct _cycleitem {
    char altname[6];
} cycleitem;

typedef struct _menuitem {
    char name[6];
    unsigned char type;//menutype type;
    union _menuitemdata {
        struct _menuitem* submenu;
        struct {
            cycleitem* cycleitems;
            unsigned short selected;
        } a;
        char altname[6];
        struct {
            unsigned char step;
            union {
                struct {
                    short val;
                    short min;
                    short max;
                } num;
                int val;
                int time;
                clockmode mode;
            } c;
        } b;
    } data;
} menuitem;

typedef struct _menustate {
    unsigned char sub[4];
    unsigned char level;
    int edit_num;
} menustate;

/*
#define K_UP     'A'
#define K_DOWN   'B'
#define K_RIGHT  'C'
#define K_LEFT   'D'
#define K_ENTER  '\n'
#define K_ESCAPE 127
#define K_REC    'r'
*/

typedef enum { menu_exit, menu_cycle_change, menu_updownlist_change } menu_callback_type;
typedef void (*menu_callback)(menu_callback_type, menuitem* item);

__attribute__((mips16)) void menu_init(menuitem* menus, menustate* state);
__attribute__((mips16)) void menu_show(menuitem* menus, menustate* state, char* tohere, unsigned char* new_dps, char* flashing);
__attribute__((mips16)) int menu_handle_keypress(menuitem* menus, menustate* state, int key, unsigned char emulated, menu_callback callback);
__attribute__((mips16)) int menu_save_state(const menuitem* menus, int* tohere);
__attribute__((mips16)) int menu_restore_state(menuitem* menus, const int* fromhere);
__attribute__((mips16)) void menu_load_settings_from_flash(menuitem* menus, int start_addr);
__attribute__((mips16)) void menu_save_settings_to_flash(menuitem* menus, int start_addr);
__attribute__((mips16)) menuitem* menu_get_current_item(menuitem* menus, menustate* state, unsigned char extra_level);
__attribute__((mips16)) int menu_get_cycle_item_index(cycleitem* items, const char* string);
__attribute__((mips16)) menuitem* menu_get_submenu(menuitem* menus, menustate* state, unsigned char* editing);
__attribute__((mips16)) unsigned char menu_currentitem_handles_alarm_on_key(menuitem* menus, menustate* state);

#ifdef	__cplusplus
}
#endif

#endif	/* MENU_H */

